/**************************************************************************
* DSemu: ARM Generic register structure and constants (arm.h)             *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __ARM_H_
#define __ARM_H_

#include "defs.h"
#include "cache.h"

//---ARM registers structure-----------------------------------------------

typedef struct {
  u32 r[16];
  u32 flags[8];
  u32 cpsr, spsr[7];
  u32 curop; u32 curmode;
  __int64 clock;

  u32 tmp1, tmp2, tmp3, tmp4, tmpc;

  u32 r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14, r15;
  u32 r8fiq, r9fiq, r10fiq, r11fiq, r12fiq, r13fiq, r14fiq;
  u32 r13svc, r14svc, r13abt, r14abt, r13irq, r14irq, r13und, r14und;

//  RAMWORD pipe0, pipe1, pipe2;

  u32 cp15[16];

} ARMREGS;

#define ARMREG_R0    0
#define ARMREG_R1    1
#define ARMREG_R2    2
#define ARMREG_R3    3
#define ARMREG_R4    4
#define ARMREG_R5    5
#define ARMREG_R6    6
#define ARMREG_R7    7
#define ARMREG_R8    8
#define ARMREG_R9    9
#define ARMREG_R10  10
#define ARMREG_R11  11
#define ARMREG_R12  12
#define ARMREG_R13  13
#define ARMREG_R14  14
#define ARMREG_R15  15
#define ARMREG_FN   16
#define ARMREG_FZ   17
#define ARMREG_FC   18
#define ARMREG_FV   19
#define ARMREG_FT   20
#define ARMREG_FQ   21


#define ARMREG_CPSR 24
#define ARMREG_SUSR 25
#define ARMREG_SSYS 26
#define ARMREG_SFIQ 27
#define ARMREG_SIRQ 28
#define ARMREG_SSVC 29
#define ARMREG_SABT 30
#define ARMREG_SUND 31
#define ARMREG_OP   32
#define ARMREG_MODE 33
#define ARMREG_T1   36
#define ARMREG_T2   37
#define ARMREG_T3   38
#define ARMREG_T4   39
#define ARMREG_TC   40
#define ARMREG_USER 41

//---ARM Flags register----------------------------------------------------

#define ARMS_N 0x80000000            // Negative
#define ARMS_Z 0x40000000            // Zero
#define ARMS_C 0x20000000            // Carry
#define ARMS_V 0x10000000            // Overflow
#define ARMS_Q 0x08000000            // DSP Overflow/Saturated
#define ARMS_I 0x00000080            // Interrupts Disabled
#define ARMS_F 0x00000040            // Fast Interrupts Disabled
#define ARMS_T 0x00000020            // Thumb Mode
#define ARMS_M 0x0000001F            // CPSR Mode Mask

#define ARMFLAG_N 0
#define ARMFLAG_Z 1
#define ARMFLAG_C 2
#define ARMFLAG_V 3
#define ARMFLAG_T 4

#define ARMFLGCHK_N (arm7reg.flags[ARMFLAG_N]&1)
#define ARMFLGCHK_Z (arm7reg.flags[ARMFLAG_Z]&1)
#define ARMFLGCHK_C (arm7reg.flags[ARMFLAG_C]&1)
#define ARMFLGCHK_V (arm7reg.flags[ARMFLAG_V]&1)

#define ARMS_M_USR 0x00000010        // User mode
#define ARMS_M_FIQ 0x00000011        // Fast Interrupt mode
#define ARMS_M_IRQ 0x00000012        // Interrupt mode
#define ARMS_M_SVC 0x00000013        // Supervisor mode
#define ARMS_M_ABT 0x00000017        // Abort mode
#define ARMS_M_UND 0x0000001B        // Undefined-instruction mode
#define ARMS_M_SYS 0x0000001F        // System mode

#define ARMMD_USR 0
#define ARMMD_SYS 1
#define ARMMD_FIQ 2
#define ARMMD_IRQ 3
#define ARMMD_SVC 4
#define ARMMD_ABT 5
#define ARMMD_UND 6

//---Exception vectors-----------------------------------------------------

#define ARMX_RST 0x00000000          // Reset vector
#define ARMX_UND 0x00000004          // Undefined-instruction vector
#define ARMX_SWI 0x00000008          // SWI vector
#define ARMX_ABI 0x0000000C          // Instruction abort vector
#define ARMX_ABD 0x00000010          // Data abort vector
#define ARMX_RSV 0x00000014          // [Reserved]
#define ARMX_IRQ 0x00000018          // IRQ vector
#define ARMX_FIQ 0x0000001C          // Fast IRQ vector

//---High-address exception vectors----------------------------------------

#define ARMXHI_RST 0xFFFF0000
#define ARMXHI_UND 0xFFFF0004
#define ARMXHI_SWI 0xFFFF0008
#define ARMXHI_ABI 0xFFFF000C
#define ARMXHI_ABD 0xFFFF0010
#define ARMXHI_RSV 0xFFFF0014
#define ARMXHI_IRQ 0xFFFF0018
#define ARMXHI_FIQ 0xFFFF001C

//---Opcode field masks----------------------------------------------------

#define ARMMSK_COND 0xF0000000        // Condition held in top 4 bits
#define ARMMSK_OP   0x0FF00000

#define ARMMSK_RN   0x000F0000
#define ARMMSK_RD   0x0000F000
#define ARMMSK_RS   0x00000F00
#define ARMMSK_RM   0x0000000F

#define ARMTMSK_RD  0x0007
#define ARMTMSK_RN  0x0038
#define ARMTMSK_RM  0x01C0

//---Condition table (indexed by condition/z/c/n/v)------------------------
/*
u8 ARMcond[16][2][2][2][2]={
    0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1, //EQ
    1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0, //NE
    0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1, //CS
    1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0, //CC
    0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1, //MI
    1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0, //PL
    0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1, //VS
    1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0, //VC
    0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0, //HI
    1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1, //LS
    1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1, //GE
    0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0, //LT
    1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0, //GT
    0,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1, //LE
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, //AL
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, //NV
};
*/
#endif//__ARM_H_

/*** EOF:arm.h ***********************************************************/
