/**************************************************************************
* DSemu: ARM7 Specific registers and fields (arm7.h)                      *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __ARM7_H_
#define __ARM7_H_

#include "arm.h"

ARMREGS arm7reg;

#define ARM7OP_RN ((arm7reg.curop&ARMMSK_RN)>>16)
#define ARM7OP_RD ((arm7reg.curop&ARMMSK_RD)>>12)
#define ARM7OP_RS ((arm7reg.curop&ARMMSK_RS)>>8)
#define ARM7OP_RM (arm7reg.curop&ARMMSK_RM)

#define ARM7TOP_RD (arm7reg.curop&ARMTMSK_RD)
#define ARM7TOP_RN ((arm7reg.curop&ARMTMSK_RN)>>3)
#define ARM7TOP_RM ((arm7reg.curop&ARMTMSK_RM)>>6)

#define ARM7TOP_RDH ((arm7reg.curop&ARMTMSK_RD)|((arm7reg.curop&0x0080)>>4))
#define ARM7TOP_RNH (((arm7reg.curop&ARMTMSK_RN)>>3)|((arm7reg.curop&0x0040)>>3))

#endif//__ARM7_H_

/*** EOF:arm7.h **********************************************************/

