/**************************************************************************
* DSemu: Debugger fixed-width bitmap font handling (dbgout.c)             *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include <windows.h>
#include "font5x7.h"
#include "dbgout.h"

void fontChar(u16 *buf, int xdim, int ydim, int x, int y, u8 c, u16 col)
{
    int off=(x+y*xdim),a,b; u8 *fontch; u8 bits;
    c-=32;

    for(a=0;a<7;a++)
    {
        bits=font5x7[c][a];
        if(bits&16) buf[off]=col; off++;
        if(bits&8)  buf[off]=col; off++;
        if(bits&4)  buf[off]=col; off++;
        if(bits&2)  buf[off]=col; off++;
        if(bits&1)  buf[off]=col; off+=(xdim-4);
    }
}

void fontStr(u16 *buf, int xdim, int ydim, int x, int y, char *str, u16 col)
{
    int xorig=x;
    while(*str)
    {
        switch(*str)
        {
            case 10: y+=8; x=xorig; break;
            default: fontChar(buf, xdim, ydim, x, y, *str, col); x+=6; break;
        }
	str++;
    }
}

void dbgOutClear(u16 *buf, int xdim, int ydim)
{
    memset(buf, 0, xdim*ydim*2);
}

void dbgOut(u16 *buf, int xdim, int ydim, char *str, int x, int y, u16 col)
{
//    fontStr(buf, xdim, ydim, x, y, dbg, col);
    int xorig=x;
    while(*str)
    {
        switch(*str)
        {
            case 10: y+=8; x=xorig; break;
            default: fontChar(buf, xdim, ydim, x, y, *str, col); x+=6; break;
        }
	str++;
    }
}

/*** EOF:dbgout.c ********************************************************/

