/**************************************************************************
* DSemu: System-wide integer size definitions (defs.h)                    *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __DEFS_H_
#define __DEFS_H_

#include "config.h"

#ifndef FALSE
#define FALSE 1
#endif

#ifndef TRUE
#define TRUE 0
#endif

#define u8  unsigned char
#define u16 unsigned short
#define u32 unsigned int

#define s8  signed char
#define s16 signed short
#define s32 signed int

#define OPCODE int

typedef void (*fptr)();
typedef int (*intfptr)();
typedef OPCODE (*opfptr)();

#ifndef _MSC_VER
#define __int64 long long
#endif

#define PLUGIN_CPU 1
#define PLUGIN_MMU 2
#define PLUGIN_GPU 3
#define PLUGIN_APU 4

#endif//__DEFS_H_

/*** EOF:defs.h **********************************************************/

