/**************************************************************************
* DSemu: Direct Memory Access operation (dma.c)                           *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include "dma.h"
#include "dsioreg.h"

void DMA3()
{
    char str[512];
    u32 src, dest, size, a, w; u16 h,hl,hh; int wordsize, srcinc, destinc;

    hl=REG(DMA3SAD_L); hh=REG(DMA3SAD_H); src =hl+(hh<<16);
    hl=REG(DMA3DAD_L); hh=REG(DMA3DAD_H); dest=hl+(hh<<16);
    if(REG(DMA3CNT_H)&DMA_TYPEMSK) wordsize=4; else wordsize=2;
    size=REG(DMA3CNT_L)*wordsize;
//    sprintf(str,"DMA3: %04Xh bytes from %08X to %08X.",size,src,dest);
//    logvt->append(str);
    switch(REG(DMA3CNT_H)&DMA_SRCMSK)
    {
        case DMA_SRCINC: srcinc=wordsize; break;
        case DMA_SRCDEC: srcinc=-wordsize; break;
        case DMA_SRCFIX: srcinc=0; break;
        case DMA_SRCINR: srcinc=wordsize; break;
    }
    switch(REG(DMA3CNT_H)&DMA_DESTMSK)
    {
        case DMA_DESTINC: destinc=wordsize; break;
        case DMA_DESTDEC: destinc=-wordsize; break;
        case DMA_DESTFIX: destinc=0; break;
        case DMA_DESTINR: destinc=wordsize; break;
    }
//    sprintf(str,"DMA3: srcinc=%d, destinc=%d", srcinc, destinc);
//    logvt->append(str);
    if(wordsize==2)
    {
        for(a=0;a<size;a+=2)
        {
            h=MMUrdH(0,src); MMUwrH(0,dest,h);
            src+=srcinc; dest+=destinc;
	}
    } else {
        for(a=0;a<size;a+=4)
        {
            w=MMUrdW(0,src); MMUwrW(0,dest,w);
            src+=srcinc; dest+=destinc;
	}
    }
}

void DMA3log()
{
}

void DMAcheck(u16 activate)
{
    static u16 oldcnt3=0;
    if(REG(DMA3CNT_H)!=oldcnt3)
    {
        oldcnt3=REG(DMA3CNT_H);
        if(oldcnt3&DMA_EN)
        {
	    if(activate==(oldcnt3&DMA_TIMEMSK)) DMA3();
            REG(DMA3CNT_H)&=0x7FFF;
            if(oldcnt3&DMA_REPEAT) REG(DMA3CNT_H)|=DMA_EN;
        }
    }
}

/*** EOF:dma.c ***********************************************************/

