/**************************************************************************
* DSemu: Interrupt triggering and flag clear (int.c)                      *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include "defs.h"
#include "int.h"
#include "arm7.h"
#include "ioreg.h"

u16 intFired=0;
extern u16 intrBitmask;

void IntFire(u16 interrupt)
{
    if(REG(IME))
    {
	if((intrBitmask&interrupt) && (REG(IE)&interrupt))
	{
	    REG(IF)|=interrupt;
	    intFired=interrupt;
	    ARM7irq();
	}
    }
}

void IntClear(u16 interrupt)
{
    REG(IF)&=(0xFFFF-interrupt);
}

/*** EOF:int.c ***********************************************************/

