/**************************************************************************
* DSemu: Interrupt flag constants (int.h)                                 *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __INT_H_
#define __INT_H_

#include "defs.h"

void IntFire(u16);
void IntClear(u16);

#define INT_VBLANK     1
#define INT_HBLANK     2
#define INT_VCOUNT     4
#define INT_TIMER0     8
#define INT_TIMER1    16
#define INT_TIMER2    32
#define INT_TIMER3    64
#define INT_SERIAL   128
#define INT_DMA0     256
#define INT_DMA1     512
#define INT_DMA2    1024
#define INT_DMA3    2048
#define INT_KEY     4096
#define INT_CART    8192

#endif//__INT_H_

/*** EOF:int.h ***********************************************************/

