/**************************************************************************
* DSemu: Window constant and menu handling definitions (win.h)            *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __WIN_H_
#define __WIN_H_

#include <windows.h>

void ResizeWin(HWND, int, int);
HWND WinInit(HINSTANCE, int);

HACCEL accelTable;

#define WM_STATUSFPS WM_APP
#define WM_OFFRESET  WM_APP+1

#define MITEM(id,stat) EnableMenuItem(hMenu, ID_MENU_##id, MF_BYCOMMAND|(stat))

#define MITEMS_STOP() \
    MITEM(FILE_CLOSE,MF_GRAYED); \
    MITEM(DBG_RUN,   MF_GRAYED); \
    MITEM(DBG_PAUSE, MF_GRAYED); \
    MITEM(DBG_RESET, MF_GRAYED); \
    MITEM(DBG_STEP,  MF_GRAYED); \
    MITEM(DBG_ASTEP, MF_GRAYED); \
    MITEM(DBG_LINE,  MF_GRAYED); \
    MITEM(DBG_ALINE, MF_GRAYED); \
    MITEM(VIEW_GPU,  MF_GRAYED); \
    MITEM(VIEW_FPS,  MF_GRAYED); \
    MITEM(VIEW_PAL,  MF_GRAYED); \
    MITEM(VIEW_DBG,  MF_GRAYED); \
    MITEM(VIEW_MEM,  MF_GRAYED)

/*    CheckMenuItem(hMenu, ID_MENU_VIEW_FPS, MF_BYCOMMAND|MF_UNCHECKED); \
    CheckMenuItem(hMenu, ID_MENU_VIEW_PAL, MF_BYCOMMAND|MF_UNCHECKED); \
    CheckMenuItem(hMenu, ID_MENU_VIEW_DBG, MF_BYCOMMAND|MF_UNCHECKED); \
    CheckMenuItem(hMenu, ID_MENU_VIEW_MEM, MF_BYCOMMAND|MF_UNCHECKED)*/

#define MITEMS_START() \
    MITEM(FILE_CLOSE,MF_ENABLED); \
    MITEM(DBG_RUN,   MF_ENABLED); \
    MITEM(DBG_PAUSE, MF_ENABLED); \
    MITEM(DBG_RESET, MF_ENABLED); \
    MITEM(DBG_STEP,  MF_ENABLED); \
    MITEM(DBG_ASTEP, MF_ENABLED); \
    MITEM(DBG_LINE,  MF_ENABLED); \
    MITEM(DBG_ALINE, MF_ENABLED); \
    MITEM(VIEW_GPU,  MF_ENABLED); \
    MITEM(VIEW_FPS,  MF_ENABLED); \
    MITEM(VIEW_PAL,  MF_ENABLED); \
    MITEM(VIEW_DBG,  MF_ENABLED); \
    MITEM(VIEW_MEM,  MF_ENABLED)

#define MITEMS_PAUSE() \
    MITEM(DBG_RUN,   MF_ENABLED); \
    MITEM(DBG_PAUSE, MF_GRAYED);  \
    MITEM(DBG_RESET, MF_ENABLED); \
    MITEM(DBG_STEP,  MF_ENABLED); \
    MITEM(DBG_ASTEP, MF_ENABLED); \
    MITEM(DBG_LINE,  MF_ENABLED); \
    MITEM(DBG_ALINE, MF_ENABLED)

#define MITEMS_RUN() \
    MITEM(DBG_RUN,   MF_GRAYED); \
    MITEM(DBG_PAUSE, MF_ENABLED);  \
    MITEM(DBG_RESET, MF_ENABLED); \
    MITEM(DBG_STEP,  MF_GRAYED); \
    MITEM(DBG_ASTEP, MF_GRAYED); \
    MITEM(DBG_LINE,  MF_GRAYED); \
    MITEM(DBG_ALINE, MF_GRAYED)

#endif//__WIN_H_

/*** EOF:win.h ***********************************************************/

